/*
 * This file is part of Remote Support Desktop
 * https://gitlab.das-netzwerkteam.de/RemoteWebApp/remote-support-desktop
 * Copyright 2020 Daniel Teichmann <daniel.teichmann@das-netzwerkteam.de>
 * Copyright 2020 Mike Gabriel <mike.gabriel@das-netzwerktea.de>
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#pragma once

#include "main_qmladaptor.h"

MainQMLAdaptor::MainQMLAdaptor(QObject *parent, QQmlApplicationEngine* engine) : QObject(parent)
{
    _engine = engine;
}

//void MainQMLAdaptor::setSession(Session session) {
//    _session = session;
//}

bool MainQMLAdaptor::setConnectButtonEnabled(bool enabled) {
    // Find item via 'objectName'
    QQuickItem *item = _engine->rootObjects().at(0)->findChild<QQuickItem*>("start_support_button");
    if (item) {
        item->setProperty("enabled", enabled);
        if (item->property("checked").toBool()) {
            item->setProperty("text", tr("Stop remote support session"));
        } else {
            item->setProperty("text", tr("Start remote support session"));
        }
    } else {
        qWarning() << "Unable to find 'start_support_button' Item!";
        return false;
    }

    return true;
}

bool MainQMLAdaptor::setConnectButtonChecked(bool checked) {
    // Find item via 'objectName'
    QQuickItem *item = _engine->rootObjects().at(0)->findChild<QQuickItem*>("start_support_button");
    if (item) {
        item->setProperty("checked", checked);
    } else {
        qWarning() << "Unable to find 'start_support_button' Item!";
        return false;
    }

    return true;
}

bool MainQMLAdaptor::setStatus(QString status) {
    // Find item via 'objectName'
    QQuickItem *item = _engine->rootObjects().at(0)->findChild<QQuickItem*>("dbus_api_status_text");
    if (item) {
        item->setProperty("text", status);
    } else {
        qWarning() << "Unable to find 'dbus_api_status_text' Item!";
        return false;
    }

    return true;
}

bool MainQMLAdaptor::openMessageDialog(QString title, QString text, QMessageBox::Icon icon) {
    _messageDialogText  = text;
    _messageDialogTitle = title;
    _messageDialogIcon  = icon;
    _showMessageDialog = true;
    emit messageDialogIconChanged(_messageDialogIcon);
    emit messageDialogTitleChanged(_messageDialogTitle);
    emit messageDialogTextChanged(_messageDialogText);

    emit showMessageDialogChanged(_showMessageDialog);

    qDebug() << "Opening MessageDialog!";
    return true;
}

QString MainQMLAdaptor::getMessageDialogTitle() {
    return _messageDialogTitle;
}

QString MainQMLAdaptor::getMessageDialogText() {
    return _messageDialogText;
}

QMessageBox::Icon MainQMLAdaptor::getMessageDialogIcon() {
    return _messageDialogIcon;
}

bool MainQMLAdaptor::getShowMessageDialog() {
    return _showMessageDialog;
}

bool MainQMLAdaptor::setStatusIndicator(bool active, QColor color) {
    // Find item via 'objectName'
    QQuickItem *item = _engine->rootObjects().at(0)->findChild<QQuickItem*>("dbus_api_status_indicator");
    if (item) {
        item->setProperty("active", active);
        item->setProperty("color", color);
    } else {
        qWarning() << "Unable to find 'dbus_api_status_indicator' Item!";
        return false;
    }

    return true;
}

void MainQMLAdaptor::handleCopyToClipboardButtonClick(QString copy_data) {
    QClipboard *clipboard = QApplication::clipboard();
    QString originalText = clipboard->text();
    clipboard->setText(copy_data);
    qDebug() << "Copied into clipboard:" << copy_data;
}

void MainQMLAdaptor::handleConnectButtonClick(bool checked) {
    emit onConnectButtonClick(checked);
}

void MainQMLAdaptor::setPin(QString pin) {
    _pin = pin;
    emit pinChanged(pin);
}
void MainQMLAdaptor::setURL(QString URL) {
    _url = URL;
    emit urlChanged(URL);
}
QString MainQMLAdaptor::getURL() {
    return _url;
}
QString MainQMLAdaptor::getPin() {
    return _pin;
}

void MainQMLAdaptor::onCloseHandler() {
    // Do cleanup things here...
    emit onCloseSignal();
}

void MainQMLAdaptor::showToast(QString text, uint durationMs) {
    emit showToastSignal(text, QString::number(durationMs));
}

//void MainQMLAdaptor::onCloseHandler() {
//    qDebug() << "Inside MainQMLAdaptor::onCloseHandler()";

//    // Sending onClose signal to main and there to Session::onCloseHandler()
//    emit MainQMLAdaptor::onCloseSignal();
//}
