/*
 * This file is part of Remote Support Desktop
 * https://gitlab.das-netzwerkteam.de/RemoteWebApp/remote-support-desktop
 * Copyright 2020 Daniel Teichmann <daniel.teichmann@das-netzwerkteam.de>
 * Copyright 2020 Mike Gabriel <mike.gabriel@das-netzwerktea.de>
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#pragma once

#include <QObject>
#include <QQmlApplicationEngine>
#include <QQuickItem>
#include <QMessageBox>
#include <QApplication>
#include <QClipboard>

//#include "session.cpp"

class MainQMLAdaptor : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QString url READ getURL WRITE setURL NOTIFY urlChanged) // this makes url available as a QML property
    Q_PROPERTY(QString pin READ getPin WRITE setPin NOTIFY pinChanged) // this makes pin available as a QML property
    Q_PROPERTY(bool     showMessageDialog  READ getShowMessageDialog  NOTIFY showMessageDialogChanged)  // this makes showMessageDialog available as a QML property
    Q_PROPERTY(QString _messageDialogTitle READ getMessageDialogTitle NOTIFY messageDialogTitleChanged) // this makes showMessageDialogTitle available as a QML property
    Q_PROPERTY(QString _messageDialogText  READ getMessageDialogText  NOTIFY messageDialogTextChanged)  // this makes showMessageDialogText available as a QML property
    Q_PROPERTY(QMessageBox::Icon _messageDialogIcon READ getMessageDialogIcon NOTIFY messageDialogIconChanged)  // this makes showMessageDialogIcon available as a QML property
public:
    explicit MainQMLAdaptor(QObject *parent, QQmlApplicationEngine *engine = nullptr);

//    void setSession(Session session);

    bool setConnectButtonEnabled(bool enabled);
    bool setConnectButtonChecked(bool checked);

    bool setStatusIndicator(bool active, QColor color = QColor(255,255,255));
    bool setStatus(QString status);

    bool openMessageDialog(QString title, QString text, QMessageBox::Icon);
    QString getMessageDialogTitle();
    QString getMessageDialogText();
    QMessageBox::Icon getMessageDialogIcon();
    bool getShowMessageDialog();
signals:
    void showMessageDialogChanged(bool show);
    void messageDialogTextChanged(QString text);
    void messageDialogTitleChanged(QString title);
    void messageDialogIconChanged(int iconindex);

    void minimizeWindow();
    void showWindow();

    void onConnectButtonClick(bool checked);

    void pinChanged(QString pin);
    void urlChanged(QString URL);

    void onCloseSignal();

    void showToastSignal(QString text, QString durationMs);

protected:
    QString _url;
    QString _pin;
private:
    QQmlApplicationEngine* _engine;

    bool _showMessageDialog;
    QString _messageDialogTitle;
    QString _messageDialogText;
    QMessageBox::Icon _messageDialogIcon;

public slots:
    void handleCopyToClipboardButtonClick(QString copy_data);
    void handleConnectButtonClick(bool checked);

    void setPin(QString pin);
    void setURL(QString URL);
    QString getURL();
    QString getPin();

    void onCloseHandler();

    void showToast(QString text, uint durationMs = 3000);
};
