# This file is part of Remote Support Desktop
# https://gitlab.das-netzwerkteam.de/RemoteWebApp/rwa.support.desktopapp
# Copyright 2021 Daniel Teichmann <daniel.teichmann@das-netzwerkteam.de>
# Copyright 2021 Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

QT += quick
QT += quickcontrols2
QT += widgets

message(Building with DBUS (Freedesktop notifications) support)
DEFINES += USE_DBUS
QT += dbus

CONFIG += c++11

# The following define makes your compiler emit warnings if you use
# any Qt feature that has been marked deprecated (the exact warnings
# depend on your compiler). Refer to the documentation for the
# deprecated API to know how to port your code away from it.
DEFINES += QT_DEPRECATED_WARNINGS

# You can also make your code fail to compile if it uses deprecated APIs.
# In order to do so, uncomment the following line.
# You can also select to disable deprecated APIs only up to a certain version of Qt.
DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000
# disables all the APIs deprecated before Qt 6.0.0

SOURCES += src/main.cpp \
    src/main_qmladaptor.cpp \
    src/RWADBusAdaptor.cpp \
    src/session.cpp \
    src/RWAHostModel.cpp \
    src/RWAHost.cpp \
    src/DBusAPI.cpp \
    src/scenes/remote_control/remote_control_manager.cpp \
    src/scenes/add_rwahost_wizard/add_rwahost_wizard.cpp

HEADERS += src/RWADBusAdaptor.h \
    src/main_qmladaptor.h \
    src/RWADBusAdaptor.h \
    src/scenes/remote_control/remote_control_manager.h \
    src/session.h \
    src/RWAHostModel.h \
    src/RWAHost.h \
    src/DBusAPI.h \
    src/scenes/remote_control/remote_control_manager.h \
    src/scenes/add_rwahost_wizard/add_rwahost_wizard.h

TRANSLATIONS += locales/main_en.ts \
    locales/de_DE.ts \
    locales/es_ES.ts

RESOURCES += qml.qrc

# Additional import path used to resolve QML modules in Qt Creator's code model
QML_IMPORT_PATH = src/scenes

# Additional import path used to resolve QML modules just for Qt Quick Designer
QML_DESIGNER_IMPORT_PATH =

# Default rules for deployment.
qnx: target.path = /tmp/$${TARGET}/bin
else: unix:!android: target.path = /opt/$${TARGET}/bin
!isEmpty(target.path): INSTALLS += target

#DISTFILES +=

CONFIG(release, debug|release):DEFINES += QT_NO_DEBUG_OUTPUT
