/*
 * This file is part of Remote Support Desktop
 * https://gitlab.das-netzwerkteam.de/RemoteWebApp/rwa.support.desktopapp
 * Copyright 2021 Daniel Teichmann <daniel.teichmann@das-netzwerkteam.de>
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef DBUSAPI_H
#define DBUSAPI_H

#include <QObject>
#include <QtDBus/QtDBus>

#include "RWAHost.h"
#include "RWADBusAdaptor.h"

class DBusAPI : public QObject {
    Q_OBJECT
public:
    explicit DBusAPI();

signals:
    void serviceStartResponse(QJsonDocument*);
    void serviceStopResponse(QJsonDocument*);
    void serviceStatusResponse(QJsonDocument*);

    void serviceGetWebAppHostsResponse(QJsonDocument*);
    void serviceAddWebAppHostResponse(QJsonDocument*);
    void serviceRemoveWebAppHostResponse(QJsonDocument*);

public slots:
    void start_reply(QDBusPendingCallWatcher *call);
    void stop_reply(QDBusPendingCallWatcher *call);
    void status_reply(QDBusPendingCallWatcher *call);

    void get_web_app_hosts_reply(QDBusPendingCallWatcher *call);
    void add_web_app_host_reply(QDBusPendingCallWatcher *call);
    void remove_web_app_host_reply(QDBusPendingCallWatcher *call);


    // Starts a remote web app session
    void start_request(RWAHost *host);

    // Stop a remote web app session
    void stop_request(RWAHost *host, QString session_id);

    // Refreshes a remote web app session's status
    void refresh_status_request(RWAHost *host, QString session_id);

    // Gets a remote web app session's status
    void status_request(RWAHost *host, QString session_id);

    // Gets all remote web app hosts deposited in the session server
    void get_web_app_hosts_request();

    // Add a specific remote web app host using a url to make sure its contactable
    void add_web_app_host_request(QString host_url, QString host_alias);

    // Removes a specific remote web app host using the uuid of a host
    void remove_web_app_host_request(QString host_uuid);

private:
    OrgArcticaProjectRWASupportSessionServiceInterface* _dbus_rwa;

    void _initDBus();

};

#endif // DBUSAPI_H
