import QtQuick 2.9
import QtQuick.Window 2.2
import QtQuick.Extras 1.4
import QtQuick.Controls 2.2
import QtQuick.Controls.Material 2.3
import rwa.toast.type 1.0

/*!
  * This .qml file is a Scene which can be loaded through for
  * example a StackView (main_content in main.qml).
  */

Item {
    id: scene_server_wizard_step_1
    objectName: "Scene_step_1"

    Connections {
        target: add_rwahost_wizard
        function onStep1Success() {
            // Go onto the first page of the stack.
            main_content_pop(null)
            mainqmladaptor.showToast(qsTr("Successfully added remote web app host."),
                                     5000,
                                     ToastType.ToastSuccess);
        }
    }

    Connections {
        target: add_rwahost_wizard
        function onStep1Failed(reason, toast_type) {
            mainqmladaptor.showToast(reason,
                                     5000,
                                     toast_type)
        }
    }

    Rectangle {
        id: rectangle
        anchors.fill: parent
        color: Material.background

        Button {
            id: next_step1_button
            text: qsTr("Next Step")
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 15
            anchors.right: parent.right
            anchors.rightMargin: 15

            onClicked: {
                add_rwahost_wizard.processStep1(host_url.text, host_alias.text)
            }
        }

        /*Text {
            color: Material.foreground
            id: step_indicator

            text: qsTr("Step 1")
            anchors.leftMargin: 15
            anchors.top: parent.top
            anchors.topMargin: 15
            font.pointSize: 21
            wrapMode: Text.WordWrap

            font.bold: true
            horizontalAlignment: Text.AlignHCenter
            anchors.left: parent.left
            anchors.margins: 5
        }*/

        Text {
            color: Material.foreground
            id: explaining_text

            text: qsTr("Please input the address for the "+
                       "remote web app server which you want "+
                       "to connect to.\nIf you don't know "+
                       "what this means, ask your local "+
                       "administrator about it please.\nBefore you can "+
                       "start any remote sessions you will have to "+
                       "be approved for remote support.")
            font.pointSize: 12
            anchors.right: parent.right
            anchors.rightMargin: 15
            anchors.leftMargin: 15
            anchors.top: parent.top //step_indicator.bottom
            anchors.topMargin: 15
            wrapMode: Text.WordWrap

            anchors.left: parent.left
            anchors.margins: 5
        }

        TextField {
            id: host_url
            selectByMouse: true
            placeholderText: qsTr("http://example.com:8000")

            font.pixelSize: 16
            color: Material.foreground
            anchors.topMargin: 30

            padding: 15
            topPadding: 15

            anchors.top: explaining_text.bottom
            anchors.left: parent.left
            anchors.leftMargin: 15
            anchors.right: parent.right
            anchors.margins: 30

            MouseArea {
                anchors.fill: parent
                hoverEnabled: true
                onHoveredChanged: {
                    if (containsMouse) {
                        host_url_background.state = "hovered"
                    } else if (!host_url.focus) {
                        host_url_background.state = "unhovered"
                    }
                }
                onClicked: {
                    host_url.forceActiveFocus();
                }
            }

            onFocusChanged: {
                host_url_background.state = host_url.focus ? "hovered" : "unhovered"
            }

            background: Rectangle {
                id: host_url_background
                color: Material.background
                border.color: Material.foreground
                border.width: 1
                radius: 4

                states: [
                    State {
                        name: "hovered"
                        PropertyChanges {
                            target: host_url_background
                            border.color: "#0178EF"
                        }
                    },
                    State {
                        name: "unhovered"
                        PropertyChanges {
                            target: host_url_background
                            border.color: Material.foreground
                        }
                    }
                ]
                transitions: [
                    Transition {
                        from: "*"
                        to: "*"
                        PropertyAnimation {
                            property: "border.color"
                            duration: 100
                            easing.type: Easing.Linear
                        }
                    }
                ]

                Text {
                    color: Material.foreground
                    text: qsTr("RWA host address")
                    anchors.left: parent.left
                    anchors.leftMargin: 15
                    anchors.verticalCenterOffset: - host_url.height / 2
                    anchors.verticalCenter: parent.verticalCenter
                    leftPadding: 5

                    Rectangle {
                        color: Material.background
                        width: parent.width + 5 + 3
                        height: parent.height
                        z: -1
                    }
                }
            }
        }

        TextField {
            id: host_alias
            selectByMouse: true
            placeholderText: qsTr("My example host")

            font.pixelSize: 16
            color: Material.foreground

            padding: 15
            topPadding: 15

            anchors.top: host_url.bottom
            anchors.topMargin: 30
            anchors.left: parent.left
            anchors.leftMargin: 15
            anchors.right: parent.right
            anchors.margins: 30

            MouseArea {
                anchors.fill: parent
                hoverEnabled: true
                onHoveredChanged: {
                    if (containsMouse) {
                        host_alias_background.state = "hovered"
                    } else if (!host_alias.focus) {
                        host_alias_background.state = "unhovered"
                    }
                }
                onClicked: {
                    host_alias.forceActiveFocus();
                }
            }

            onFocusChanged: {
                host_alias_background.state = host_alias.focus ? "hovered" : "unhovered"
            }

            background: Rectangle {
                id: host_alias_background
                color: Material.background
                border.color: Material.foreground
                border.width: 1
                radius: 4

                states: [
                    State {
                        name: "hovered"
                        PropertyChanges {
                            target: host_alias_background
                            border.color: "#0178EF"
                        }
                    },
                    State {
                        name: "unhovered"
                        PropertyChanges {
                            target: host_alias_background
                            border.color: Material.foreground
                        }
                    }
                ]
                transitions: [
                    Transition {
                        from: "*"
                        to: "*"
                        PropertyAnimation {
                            property: "border.color"
                            duration: 100
                            easing.type: Easing.Linear
                        }
                    }
                ]

                Text {
                    color: Material.foreground
                    text: qsTr("RWA host alias")
                    anchors.left: parent.left
                    anchors.leftMargin: 15
                    anchors.verticalCenterOffset: - host_alias.height / 2
                    anchors.verticalCenter: parent.verticalCenter
                    leftPadding: 5

                    Rectangle {
                        color: Material.background
                        width: parent.width + 5 + 3
                        height: parent.height
                        z: -1
                    }
                }
            }
        }
    }
}

/*##^## Designer {
    D{i:0;autoSize:true;height:480;width:640}D{i:4;anchors_width:351;anchors_x:279}
}
 ##^##*/
