/*
 * This file is part of Remote Support Desktop
 * https://gitlab.das-netzwerkteam.de/RemoteWebApp/rwa.support.desktopapp
 * Copyright 2021 Daniel Teichmann <daniel.teichmann@das-netzwerkteam.de>
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef ADD_RWAHOST_WIZARD_H
#define ADD_RWAHOST_WIZARD_H

#include <QObject>

#include "../../RWADBusAdaptor.h"
#include "../../DBusAPI.h"
#include "../../main_qmladaptor.h"

class AddRWAHostWizard : public QObject
{
    Q_OBJECT
public:
    explicit AddRWAHostWizard(QObject *parent = nullptr,
                               MainQMLAdaptor *main_gui = nullptr,
                               DBusAPI *dbus_api = nullptr);
    void add_server(QString host_url, QString host_alias);

private:
    DBusAPI *_dbus_api;
    MainQMLAdaptor *_main_gui;

signals:
    void step1Success();
    void step1Failed(QString reason, uint toast_type);
    void step2Success();
    void step2Failed(QString reason, uint toast_type);

public slots:
    void processStep1(QString host_url, QString host_alias);
    void processStep2();

    void add_web_app_host_response(QJsonDocument *doc);
};

#endif // ADD_SERVER_WIZARD_H
