/*
 * This file is part of Remote Support Desktop
 * https://gitlab.das-netzwerkteam.de/RemoteWebApp/rwa.support.desktopapp
 * Copyright 2020, 2021 Daniel Teichmann <daniel.teichmann@das-netzwerkteam.de>
 * Copyright 2020, 2021 Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef SESSION_H
#define SESSION_H

#include <QObject>
#include <QQmlApplicationEngine>
#include <QQuickItem>
#include <QTimerEvent>
#include <QTranslator>

#include "RWAHost.h"
#include "DBusAPI.h"

class Session : public QObject {
    Q_OBJECT

public:
    explicit Session(DBusAPI *dbus_api = nullptr,
                     RWAHost *host = nullptr);
    ~Session();

    QString getStatus();
    QString getURL();
    QString getSessionID();
    QString getPin();
    RWAHost* getHost();

    void setStatus(QString status);
    void setURL(QString url);
    void setSessionID(QString session_id);
    void setPin(QString pin);
    void setHost(RWAHost *host);

    void start();
    void stop();
    void status();
    void refresh_status();

    bool started;

private:
    void statusTimerEvent();

    bool _emitted_status_error_already;
    QString _status;
    RWAHost *_host;
    DBusAPI *_dbus_api;

    QString _session_id;
    QString _url;
    QString _pin;

    bool _minimizedBefore = false;

signals:
    void statusChanged(QString);
    void sessionIDChanged(QString);
    void urlChanged(QString);
    void pinChanged(QString);
    void hostChanged(RWAHost*);

    void startFailed(QString error_message);
    void stopFailed(QString error_message);
    void statusFailed(QString error_message);

    void startSucceeded();
    void stopSucceeded();
    void statusSucceeded();

public slots:
    // Returns true if a session is somewhat usable (Running, Alive, etc..)
    bool isSessionAliveOrRunning();

    void start_response(QJsonDocument*);
    void stop_response(QJsonDocument*);
    void status_response(QJsonDocument*);
};

#endif // SESSION_H
