# RWA.Support.DesktopApp

RWA.Support is a remote support solution. The RWA.Support.DesktopApp is
the support tool provided on computers of users that shall be supported
by the IT support team.

The RWA.Support.DesktopApp has been implemented using Qt Quick / QML.


Building the project
--------------------

### Install dependencies

`sudo apt install qmlscene build-essential \
 libgles2-mesa-dev qtquickcontrols2-5-dev qtdeclarative5-dev \
 qml-module-qtquick-controls2 qml-module-qtquick-dialogs \
 qml-module-qtquick-extras`


<!-- ### Cross compiling. RWA is not available for windows at the moment!
To cross compile from linux to windows for example please look at this source

https://stackoverflow.com/questions/10934683/how-do-i-configure-qt-for-cross-compilation-from-linux-to-windows-target -->

### Clone this repo

`git clone
 https://gitlab.das-netzwerkteam.de/remotewebapp/rwa.support.desktopapp.git`

### Making the Makefile

1. `cd rwa.support.desktopapp && mkdir BUILD && cd BUILD`

2. `qmake ../rwa-support-desktopapp.pro`

qmake should have made a `Makefile` now which can be used by `make` to build an executable

### Using the Makefile to build this project

1. `make`

### Test your new executable

1. `./rwa-support-desktopapp`


Installation of dev-environment
-------------------------------

### Clone this repo

`git clone
 https://gitlab.das-netzwerkteam.de/remotewebapp/rwa.support.desktopapp.git`

### Install Qt Creator and necessary packages

`sudo apt install qtcreator qt5-default qmlscene build-essential
 libgles2-mesa-dev qtquickcontrols2-5-dev qtdeclarative5-dev
 qml-module-qtquick-controls2 qml-module-qtquick-dialogs
 qml-module-qtquick-extras`

### Import the project into Qt Creator

1. Start Qt Creator

2. Click 'Projects' button -> Click 'Open project' button

3. Navigate to your cloned 'rwa.support.desktopapp' git directory

4. Select `rwa-support-desktopapp.pro` file

### In Qt Creator while in RWA.Support.DesktopApp project:

1. Try pressing CTRL and R (Building and running the project)

2. If Qt Creator asks for an executable file in a dialog box proceed with
   next step

### Run settings

1. In the left bar click on 'Projects'

2. Then go to the 'Run' tab

3. Make sure a executable file is selected

4. Its usually `<build-dir>/../build-rwa-support-desktopapp-Desktop-Debug/rwa-support-desktopapp`

5. (Make sure that you tried to build the project at least once, or else the folder won't exist yet)

### Profit

...

### Authors, Copyright and License

This project is licensed under the GNU General Public License version 2 or (at your option) any later version.

The copyright holders of this project are

Copyright 2020-2021 Daniel Teichmann <daniel.teichmann@das-netzwerkteam.de>  
Copyright 2020-2021 Mike Gabriel <mike.gabriel@das-netzwerkteam.de>  

For further license information, see the LICENSE file in this project or
consult the invidiual license headers of the files of this project.
