/*
 * This file is part of Remote Support Desktop
 * https://gitlab.das-netzwerkteam.de/RemoteWebApp/rwa.support.desktopapp
 * Copyright 2020, 2021 Daniel Teichmann <daniel.teichmann@das-netzwerkteam.de>
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/*
 * This file was generated by qdbusxml2cpp version 0.8
 * Command line was: qdbusxml2cpp -p src/RWADBusAdaptor.h: rwa.xml
 * rwa.xml is the xml output of the Introspect D-Bus method
 *
 * qdbusxml2cpp is Copyright (C) 2017 The Qt Company Ltd.
 *
 * This is an auto-generated file.
 * Do not edit! All changes made to it will be lost.
 */

#ifndef RWADBUSADAPTOR_H
#define RWADBUSADAPTOR_H

#include <QtCore/QObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtDBus/QtDBus>

/*
 * Proxy class for interface org.ArcticaProject.RWASupportSessionService
 */
class OrgArcticaProjectRWASupportSessionServiceInterface: public QDBusAbstractInterface
{
    Q_OBJECT
public:
    static inline const char *staticInterfaceName()
    { return "org.ArcticaProject.RWASupportSessionService"; }

public:
    OrgArcticaProjectRWASupportSessionServiceInterface(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent = nullptr);

    ~OrgArcticaProjectRWASupportSessionServiceInterface();

public Q_SLOTS: // METHODS
    inline QDBusPendingReply<QString> add_web_app_host(const QString &host)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(host);
        return asyncCallWithArgumentList(QStringLiteral("add_web_app_host"), argumentList);
    }

    inline QDBusPendingReply<QString> get_web_app_hosts()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QStringLiteral("get_web_app_hosts"), argumentList);
    }

    inline QDBusPendingReply<QString> refresh_status(int pid)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(pid);
        return asyncCallWithArgumentList(QStringLiteral("refresh_status"), argumentList);
    }

    inline QDBusPendingReply<QString> remove_web_app_host(int host_idx)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(host_idx);
        return asyncCallWithArgumentList(QStringLiteral("remove_web_app_host"), argumentList);
    }

    inline QDBusPendingReply<QString> start(int host_idx)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(host_idx);
        return asyncCallWithArgumentList(QStringLiteral("start"), argumentList);
    }

    inline QDBusPendingReply<QString> status(int pid)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(pid);
        return asyncCallWithArgumentList(QStringLiteral("status"), argumentList);
    }

    inline QDBusPendingReply<QString> stop(int pid)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(pid);
        return asyncCallWithArgumentList(QStringLiteral("stop"), argumentList);
    }

Q_SIGNALS: // SIGNALS
};

/*
 * Proxy class for interface org.freedesktop.DBus.Introspectable
 */
class OrgFreedesktopDBusIntrospectableInterface: public QDBusAbstractInterface
{
    Q_OBJECT
public:
    static inline const char *staticInterfaceName()
    { return "org.freedesktop.DBus.Introspectable"; }

public:
    OrgFreedesktopDBusIntrospectableInterface(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent = nullptr);

    ~OrgFreedesktopDBusIntrospectableInterface();

public Q_SLOTS: // METHODS
    inline QDBusPendingReply<QString> Introspect()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QStringLiteral("Introspect"), argumentList);
    }

Q_SIGNALS: // SIGNALS
};

namespace org {
  namespace ArcticaProject {
    typedef ::OrgArcticaProjectRWASupportSessionServiceInterface RWASupportSessionService;
  }
  namespace freedesktop {
    namespace DBus {
      typedef ::OrgFreedesktopDBusIntrospectableInterface Introspectable;
    }
  }
}
#endif
