/*
 * This file is part of Remote Support Desktop
 * https://gitlab.das-netzwerkteam.de/RemoteWebApp/rwa.support.desktopapp
 * Copyright 2021 Daniel Teichmann <daniel.teichmann@das-netzwerkteam.de>
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef RWAHOST_H
#define RWAHOST_H

#include <QObject>
#include <QQuickItem>

class RWAHost : public QObject {
    Q_OBJECT
    Q_PROPERTY(QString uuid  READ uuid  WRITE setUuid  NOTIFY uuidChanged)
    Q_PROPERTY(QString alias READ alias WRITE setAlias NOTIFY aliasChanged)
    Q_PROPERTY(QString url   READ url   WRITE setUrl   NOTIFY urlChanged)

public:
    RWAHost(QString uuid = "", QString alias = "", QString url = "");
    RWAHost(const RWAHost&);

private:
    QString _uuid;
    QString _alias;
    QString _url;

signals:
    void uuidChanged(QString uuid);
    void aliasChanged(QString alias);
    void urlChanged(QString url);

public slots:
    QString uuid() const;
    QString alias() const;
    QString url() const;

    void setUuid(const QString &uuid);
    void setAlias(const QString &alias);
    void setUrl(const QString &url);

};

#endif // RWAHOST_H
