#include "RWAHostModel.h"

RWAHostModel::RWAHostModel(QObject *parent) {
    Q_UNUSED(parent)
}

int RWAHostModel::rowCount(const QModelIndex& parent) const {
    Q_UNUSED(parent);
    return mDatas.size();
}

int RWAHostModel::columnCount(const QModelIndex& parent) const {
    Q_UNUSED(parent);
    return 1;
}

QVariant RWAHostModel::data(const QModelIndex &index, int role) const
 {
  if (!index.isValid())
      return QVariant();
  if ( role == Qt::DisplayRole) {
          return mDatas[index.row()];
  }
  return QVariant();
}

void RWAHostModel::populate() {
    beginResetModel();
    mDatas.clear();
    RWAHost *host1 = new RWAHost("uuid-1", "Erster Server", "url1");
    RWAHost *host2 = new RWAHost("uuid-2", "Zweiter Server", "url2");
    RWAHost *host3 = new RWAHost("uuid-3", "Dritter Server", "url3");
    mDatas.append(host1->alias());
    mDatas.append(host2->alias());
    mDatas.append(host3->alias());
    endResetModel();
}
