import QtQuick 2.9
import QtQuick.Window 2.2
import QtQuick.Extras 1.4
import QtQuick.Controls 2.2
import QtQuick.Dialogs 1.2
import QtQuick.Controls.Material 2.3

/*!
  * This .qml file is a Scene which can be loaded through for
  * example a StackView (main_content in main.qml).
  */

Item {
    id: scene_no_server_available
    objectName: "Scene_no_server_available"

    Rectangle {
        id: rectangle
        anchors.fill: parent
        color: Material.background

        Text {
            color: Material.foreground
            id: title

            text: qsTr("Welcome!")
            font.pointSize: 20
            font.bold: true
            wrapMode: Text.WordWrap

            horizontalAlignment: Text.AlignLeft

            anchors.top: parent.top
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.margins: 15
        }

        Text {
            color: Material.foreground
            anchors.top: title.bottom
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.margins: 15

            horizontalAlignment: Text.AlignLeft
            wrapMode: Text.WordWrap
            /*: 'Add RWA-Server' has to be replaced with the correct translation in file main.qml .*/
            font.pointSize: 13
            text: qsTr("You need to add and select the remote \
web app server to which you want to connect. \
You can see a button to the left in the menu \
which says 'Add RWA-Server'. Follow the steps \
listed there and you can start your remote \
support session afterwards using the buttons \
above 'Add RWA-Server'.")
        }
    }
}







/*##^## Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
 ##^##*/
