import QtQuick 2.9
import QtQuick.Window 2.2
import QtQuick.Extras 1.4
import QtQuick.Controls 2.2
import QtQuick.Dialogs 1.2
import QtQuick.Controls.Material 2.3

/*!
  * This .qml file is a Scene which can be loaded through for
  * example a StackView (main_content in main.qml).
  */

Item {
    id: scene_placeholder
    objectName: "Scene_placeholder"

    Rectangle {
        id: rectangle
        anchors.fill: parent
        color: Material.background

        Text {
            color: Material.foreground
            id: title

            text: qsTr("This is the placeholder scene!")
            font.pointSize: 18
            wrapMode: Text.WordWrap

            font.bold: true
            horizontalAlignment: Text.AlignHCenter
            anchors.verticalCenter: parent.verticalCenter
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.margins: 5
        }

        Text {
            color: Material.foreground
            anchors.top: title.bottom
            anchors.margins: 5
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.right: parent.right

            wrapMode: Text.WordWrap
            text: qsTr("The features you expected here are not yet implemented.")
            horizontalAlignment: Text.AlignHCenter
        }
    }
}

/*##^## Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
 ##^##*/
