import QtQuick 2.9
import QtQuick.Window 2.2
import QtQuick.Extras 1.4
import QtQuick.Controls 2.2
import QtQuick.Dialogs 1.2
import QtQuick.Controls.Material 2.3

/*!
  * This .qml file is a Scene which can be loaded through for
  * example a StackView (main_content in main.qml).
  */

Item {
    id: scene_remote_control
    objectName: "Scene_remote_control"

    Label {
        id: dbus_api_status_text
        text: qsTr("Unknown state of session service.")
        anchors.leftMargin: 10 + 5 + dbus_api_status_indicator.width
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 10
        wrapMode: Text.WordWrap
        anchors.rightMargin: 10
        verticalAlignment: Text.AlignVCenter
        font.pointSize: 11
        fontSizeMode: Text.Fit
        objectName: "dbus_api_status_text"
        anchors.left: parent.left
        anchors.right: parent.right

        StatusIndicator {
            id: dbus_api_status_indicator
            width: height
            height: 20
            objectName: "dbus_api_status_indicator"
            color: "#73d216"
            anchors.verticalCenter: parent.verticalCenter
            anchors.right: parent.left
            anchors.rightMargin: 5
            active: false
        }
    }

    Label {
        id: explain_function_label
        text: qsTr("Please tell your remote support \
partner your access address and \
your access-PIN to let your partner \
connect to this computer.")
        wrapMode: Text.WordWrap
        font.pixelSize: 18
        anchors.topMargin: 10
        anchors.leftMargin: 10
        anchors.rightMargin: 10
        anchors.top: parent.top
        anchors.left: parent.left
        anchors.right: parent.right
        horizontalAlignment: Text.AlignLeft

        color: Material.theme == Material.Light ? "#000000" : "#FFFFFF"
    }

    Rectangle {
        id: dbus_api_status_line
        height: 1
        radius: 1
        anchors.right: parent.right
        anchors.rightMargin: 10
        anchors.bottom: dbus_api_status_text.top
        anchors.bottomMargin: 10
        opacity: 0.3
        gradient: Gradient {
            GradientStop {
                position: 0.391
                color: "#ffffff"
            }

            GradientStop {
                position: 0.975
                color: "#8b8b8b"
            }
        }
        border.width: 1
        border.color: "#00000000"
        anchors.left: parent.left
        anchors.leftMargin: 10
    }

    Column {
        id: column
        spacing: 6
        anchors.right: parent.right
        anchors.rightMargin: 10
        anchors.left: parent.left
        anchors.leftMargin: 10
        anchors.bottom: dbus_api_status_line.top
        anchors.bottomMargin: 10
        anchors.top: explain_function_label.bottom
        anchors.topMargin: 10

        Column {
            id: url_group
            width: parent.width
            height: parent.height * 0.25
            spacing: 5

            Label {
                id: your_url_text
                height: parent.height/2
                text: qsTr("Remote Support Address")
                font.weight: Font.Bold
                font.bold: true
                verticalAlignment: Text.AlignBottom
                horizontalAlignment: Text.AlignLeft
                font.pointSize: 14
                fontSizeMode: Text.Fit
            }

            TextEdit {
                id: url_text
                height: parent.height/2
                text: remote_control_manager.url
                anchors.rightMargin: 10 + copy_url_to_clipboard_button.width
                anchors.right: parent.right
                wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                anchors.leftMargin: 10
                verticalAlignment: Text.AlignVCenter
                horizontalAlignment: Text.AlignLeft
                font.pointSize: 15

                readOnly: true
                color: Material.foreground
                selectByMouse: true
                anchors.left: parent.left

                leftPadding: 5
                Rectangle {
                    radius: 5
                    color: Material.theme == Material.Light ? "#F0F0F0" : "#383838"
                    height: url_text.height
                    // whole line + copy-into-clipboard button + some margin
                    width: url_text.width + copy_url_to_clipboard_button.width + 5 + 5
                    x: 0; y: 0
                    z: -1
                }

                Button {
                    id: copy_url_to_clipboard_button
                    width: copy_url_to_clipboard_image.width + 6
                    height: copy_url_to_clipboard_image.height + 6 + 10
                    anchors.verticalCenter: parent.verticalCenter
                    display: AbstractButton.IconOnly
                    anchors.leftMargin: 5
                    anchors.left: url_text.right
                    highlighted: false
                    flat: true

                    Image {
                        id: copy_url_to_clipboard_image
                        x: 0
                        y: -26
                        anchors.horizontalCenter: parent.horizontalCenter
                        anchors.verticalCenter: parent.verticalCenter
                        source: "../../../images/into-clipboard.svg"
                        opacity: 0.65
                    }

                    onClicked: {
                        remote_control_manager.handleCopyToClipboardButtonClick(url_text.text);
                        toast.show(qsTr("Copied access address into clipboard!"),
                                   "5000",
                                   mainqmladaptor.ToastInfo);
                    }

                    ToolTip.text: qsTr("Copy the access address into the clipboard")
                    hoverEnabled: true

                    ToolTip.delay: 600
                    ToolTip.timeout: 5000
                    ToolTip.visible: hovered
                }
            }
        }

        Column {
            id: session_id_group
            width: parent.width
            height: parent.height * 0.25
            spacing: 5

            Label {
                id: your_session_id_text
                height: parent.height/2
                text: qsTr("Session-ID")
                font.weight: Font.Bold
                font.bold: true
                anchors.right: parent.right
                anchors.rightMargin: 0
                anchors.left: parent.left
                anchors.leftMargin: 0
                font.pointSize: 14
                verticalAlignment: Text.AlignBottom
                horizontalAlignment: Text.AlignLeft
                fontSizeMode: Text.Fit
            }

            TextEdit {
                objectName: "session_id_text"
                id: session_id_text
                height: parent.height/2
                text: remote_control_manager.session_id
                font.letterSpacing: 10
                anchors.rightMargin: 10 + copy_session_id_to_clipboard_button.width
                anchors.right: parent.right
                font.pointSize: 15
                anchors.left: parent.left
                anchors.leftMargin: 10
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter

                leftPadding: 5
                Rectangle {
                    radius: 5
                    color: Material.theme == Material.Light ? "#F0F0F0" : "#383838"
                    height: session_id_text.height
                    // whole line + copy-into-clipboard button + some margin
                    width: session_id_text.width + copy_session_id_to_clipboard_button.width + 5 + 5
                    x: 0; y: 0
                    z: -1
                }

                readOnly: true
                color: Material.foreground
                wrapMode: Text.WordWrap
                selectByMouse: true

                Button {
                    id: copy_session_id_to_clipboard_button
                    width: copy_session_id_to_clipboard_image.width + 6
                    height: copy_session_id_to_clipboard_image.height + 6 + 10
                    anchors.verticalCenter: parent.verticalCenter
                    flat: true
                    display: AbstractButton.IconOnly
                    anchors.left: session_id_text.right
                    anchors.leftMargin: 5

                    Image {
                        id: copy_session_id_to_clipboard_image
                        anchors.horizontalCenter: parent.horizontalCenter
                        opacity: 0.65
                        anchors.verticalCenter: parent.verticalCenter
                        source: "../../../images/into-clipboard.svg"
                        fillMode: Image.PreserveAspectFit
                    }

                    onClicked: {
                        remote_control_manager.handleCopyToClipboardButtonClick(session_id_text.text);
                        toast.show(qsTr("Copied session-ID into clipboard!"),
                                   "5000",
                                   mainqmladaptor.ToastInfo);
                    }

                    ToolTip.text: qsTr("Copy the session-ID into the clipboard")
                    hoverEnabled: true

                    ToolTip.delay: 600
                    ToolTip.timeout: 5000
                    ToolTip.visible: hovered
                }
            }
        }

        Column {
            id: pin_group
            width: parent.width
            height: parent.height * 0.25
            spacing: 5

            Label {
                id: your_pin_text
                height: parent.height/2
                text: qsTr("Access-PIN")
                font.weight: Font.Bold
                font.bold: true
                anchors.right: parent.right
                anchors.rightMargin: 0
                anchors.left: parent.left
                anchors.leftMargin: 0
                font.pointSize: 14
                verticalAlignment: Text.AlignBottom
                horizontalAlignment: Text.AlignLeft
            }

            TextEdit {
                objectName: "pin_text"
                id: pin_text
                height: parent.height/2
                text: remote_control_manager.pin
                anchors.rightMargin: 10 + copy_pin_to_clipboard_button.width
                anchors.right: parent.right
                font.pointSize: 15
                anchors.left: parent.left
                anchors.leftMargin: 10
                font.letterSpacing: 10
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter

                leftPadding: 5
                Rectangle {
                    radius: 5
                    color: Material.theme == Material.Light ? "#F0F0F0" : "#383838"
                    height: url_text.height
                    // whole line + copy-into-clipboard button + some margin
                    width: url_text.width + copy_url_to_clipboard_button.width + 5 + 5
                    x: 0; y: 0
                    z: -1
                }

                readOnly: true
                color: Material.foreground
                wrapMode: Text.WordWrap
                selectByMouse: true

                Button {
                    id: copy_pin_to_clipboard_button
                    width: copy_pin_to_clipboard_image.width + 6
                    height: copy_pin_to_clipboard_image.height + 6 + 10
                    anchors.verticalCenter: parent.verticalCenter
                    flat: true
                    display: AbstractButton.IconOnly
                    anchors.left: pin_text.right
                    anchors.leftMargin: 5

                    Image {
                        id: copy_pin_to_clipboard_image
                        anchors.verticalCenter: parent.verticalCenter
                        opacity: 0.65
                        anchors.horizontalCenter: parent.horizontalCenter
                        source: "../../../images/into-clipboard.svg"
                        fillMode: Image.PreserveAspectFit
                    }

                    onClicked: {
                        remote_control_manager.handleCopyToClipboardButtonClick(pin_text.text);
                        toast.show(qsTr("Copied PIN into clipboard!"),
                                   "5000",
                                   mainqmladaptor.ToastInfo);
                    }

                    ToolTip.text: qsTr("Copy the pin into the clipboard")
                    hoverEnabled: true

                    ToolTip.delay: 600
                    ToolTip.timeout: 5000
                    ToolTip.visible: hovered
                }
            }
        }

    }

    Button {
        id: start_support_button
        height: Math.min(50)
        objectName: "start_support_button"
        text: checked ? qsTr("Stop remote support session") : qsTr("Start remote support session")
        anchors.rightMargin: column.anchors.leftMargin
        anchors.bottom: dbus_api_status_line.top
        anchors.bottomMargin: 10
        anchors.right: parent.right
        checkable: true

        onClicked: remote_control_manager.handleConnectButtonClick(checked);
    }
}

/*##^##
Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
##^##*/
