#ifndef REMOTE_CONTROL_MANAGER_H
#define REMOTE_CONTROL_MANAGER_H

#include <QObject>

#include "../../main_qmladaptor.h"
#include "../../DBusAPI.h"
#include "../../session.h"

class RemoteControlManager : public QObject {

    Q_OBJECT
    // this makes url available as a QML property
    Q_PROPERTY(QString url READ getURL NOTIFY urlChanged)
    // this makes pin available as a QML property
    Q_PROPERTY(QString pin READ getPin NOTIFY pinChanged)
    // this makes session_id available as a QML property
    Q_PROPERTY(QString session_id READ getSessionID NOTIFY sessionIDChanged)

public:
    explicit RemoteControlManager(QQmlApplicationEngine *engine = nullptr,
                                  MainQMLAdaptor *main_gui = nullptr,
                                  DBusAPI *dbus_api = nullptr);

    bool setConnectButtonEnabled(bool enabled);
    bool setConnectButtonChecked(bool checked);
    bool setStatusIndicatorColor(bool active, QColor color = QColor(255,255,255));

    QString translateStatusIndicatorText(QString status_code);
    bool setStatusIndicatorText(QString status_text);

private:
    DBusAPI *_dbus_api;
    MainQMLAdaptor *_main_gui;
    QQmlApplicationEngine *_engine;
    Session *_current_session;
    QSet<Session*> *_sessions;

    void connectSession(Session *session);
    void connectToDBusAPI(Session *session);

    bool refreshTimerIsRunning;

signals:
    void onConnectButtonClick(bool checked);
    void pinChanged(QString pin);
    void urlChanged(QString URL);
    void sessionIDChanged(QString session_id);

public slots:
    void handleCopyToClipboardButtonClick(QString copy_data);
    void handleConnectButtonClick(bool checked);

    void setCurrentSession(Session *session);
    void addSession(Session *session);
    bool removeSession(Session *session);

    void currentSessionStatusChanged(QString);
    void currentSessionPinChanged(QString);
    void currentSessionSessionIDChanged(QString);
    void currentSessionUrlChanged(QString);

    QString getURL();
    QString getPin();
    QString getSessionID();
    Session* getCurrentSession();

    void currentSessionStartFailed(QString error_message);
    void currentSessionStopFailed(QString error_message);
    void currentSessionStatusFailed(QString error_message);
    void currentSessionUnexpectedStop(QString error_message);

    void currentSessionStartSucceeded();
    void currentSessionStopSucceeded();
    void currentSessionStatusSucceeded();
};

#endif // REMOTECONTROLMANAGER_H
